//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.Text;
using COMTypes;

namespace TypeTester
{
	public struct ComErrors
	{
		public ComErrors(string name, string exception)
		{
			this.name = name;
			this.exception = exception;
		}
		public string Name
		{
			get
			{
				return name;
			}
		}
		public string Exception
		{
			get
			{
				return exception;
			}
		}
		private string name;
		private string exception;
	}

	/// <summary>
	/// Podsumowanie dla TypeTesterForm.
	/// </summary>
	public class TypeTesterForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ColorDialog colorDialog;
		private System.Windows.Forms.Button colorButton;
		private System.Windows.Forms.TextBox colorName;
		private System.Windows.Forms.DateTimePicker dateTime;
		private System.Windows.Forms.TextBox colorNameProperty;
		private System.Windows.Forms.TextBox dateTimeProperty;
		private System.Windows.Forms.TextBox currency;
		private System.Windows.Forms.TextBox currencyProperty;
		private System.Windows.Forms.TextBox name;
		private System.Windows.Forms.TextBox nameProperty;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox variant;
		private System.Windows.Forms.TextBox variantProperty;
		private System.Windows.Forms.Label label4;
		private ITypeTest tt;
		private System.Windows.Forms.Button errorButton;
		private System.Windows.Forms.RichTextBox errorText;
		private System.Windows.Forms.GroupBox inputGroupBox;
		private System.Windows.Forms.RadioButton stringObjectRadio;
		private System.Windows.Forms.RadioButton floatObjectRadio;
		private System.Windows.Forms.RadioButton integerObjectRadio;
		private System.Windows.Forms.GroupBox propertyGroupBox;
		private System.Windows.Forms.RadioButton propertyIntegerRadio;
		private System.Windows.Forms.RadioButton propertyFloatRadio;
		private System.Windows.Forms.RadioButton propertyStringRadio;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox arrayProperty;
		private System.Windows.Forms.TextBox array;
		private System.Windows.Forms.Button enumButton;
		private System.Windows.Forms.TextBox enumeratorProperty;
		private System.Windows.Forms.TextBox callbackCounter;
		private System.Windows.Forms.ComboBox errorType;
		private ArrayList errorCollection;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private void COMCallback(int count)
		{
			callbackCounter.Text = Convert.ToString(count);
		}
		private void ArrayCallback(object objectArray)
		{
			// Odczyt tablicy
			object [] oa = (object [])objectArray;
			StringBuilder sb = new StringBuilder();
			for(int i = 0; i < oa.Length; i++)
			{
				sb.Append(oa[i]);
				if(i != oa.Length - 1)
					sb.Append(",");
			}
			arrayProperty.Text = sb.ToString();
			enumButton.Enabled = true;
		}
		private void ColorCallback(object objectColor)
		{
			colorNameProperty.Text = objectColor.ToString();
		}
		private void CurrencyCallback(decimal objectCurrency)
		{
			currencyProperty.Text = Convert.ToString(objectCurrency);
		}
		private void DateCallback(DateTime objectDate)
		{
			dateTimeProperty.Text = objectDate.ToLongDateString();
		}
		private void NameCallback(string objectName)
		{
			nameProperty.Text = objectName;		
		}
		private void ObjectCallback(object objectObject)
		{
			variantProperty.Text = Convert.ToString(objectObject);
		}
		public TypeTesterForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
			CTypeTest ctt = new CTypeTest();
			tt = ctt;
			ctt.ArrayCallback += new _ITypeTestEvents_ArrayCallbackEventHandler(ArrayCallback);
			ctt.CurrencyCallback += new _ITypeTestEvents_CurrencyCallbackEventHandler(CurrencyCallback);
			ctt.DateCallback += new _ITypeTestEvents_DateCallbackEventHandler(DateCallback);
			ctt.NameCallback += new _ITypeTestEvents_NameCallbackEventHandler(NameCallback);
			ctt.ObjectCallback += new _ITypeTestEvents_ObjectCallbackEventHandler(ObjectCallback);
			ctt.ColorCallback += new _ITypeTestEvents_ColorCallbackEventHandler(ColorCallback);
			// Ten kod znalaz si na kocu, dziki czemu asynchroniczne zdarzenia
			// nie bd odbierane w czasie ustawiania innych zdarze.
			ctt.Callback += new _ITypeTestEvents_CallbackEventHandler(COMCallback);
			stringObjectRadio.Checked = true;
			floatObjectRadio.Checked = false;
			integerObjectRadio.Checked = false;
			propertyIntegerRadio.Checked = false;
			propertyFloatRadio.Checked = false;
			propertyStringRadio.Checked = false;

			enumButton.Enabled = false;

			errorCollection = new ArrayList();

			// errorCollection.Add(new ComErrors("MSEE_E_APPDOMAINUNLOADED", "AppDomainUnloadedException"));
			// errorCollection.Add(new ComErrors("COR_E_CORE", "CoreException"));
			// errorCollection.Add(new ComErrors("COR_E_COMEMULATE_ERROR", "COMEmulateException"));
			// errorCollection.Add(new ComErrors("COR_E_WEAKREFERENCE", "WeakReferenceException"));
			// errorCollection.Add(new ComErrors("COR_E_VTABLECALLSNOTSUPPORTED", "VTableCallsNotSupportedException"));
			errorCollection.Add(new ComErrors("COR_E_APPLICATION", "ApplicationException"));
			errorCollection.Add(new ComErrors("COR_E_ARGUMENT", "ArgumentException"));
			errorCollection.Add(new ComErrors("E_INVALIDARG", "ArgumentException"));
			errorCollection.Add(new ComErrors("COR_E_ARGUMENTOUTOFRANGE", "ArgumentOutOfRangeException"));
			errorCollection.Add(new ComErrors("COR_E_ARITHMETIC", "ArithmeticException"));
			errorCollection.Add(new ComErrors("ERROR_ARITHMETIC_OVERFLOW", "ArithmeticException"));
			errorCollection.Add(new ComErrors("COR_E_ARRAYTYPEMISMATCH", "ArrayTypeMismatchException"));
			errorCollection.Add(new ComErrors("COR_E_BADIMAGEFORMAT", "BadImageFormatException"));
			errorCollection.Add(new ComErrors("ERROR_BAD_FORMAT", "BadImageFormatException"));
			errorCollection.Add(new ComErrors("COR_E_CONTEXTMARSHAL", "ContextMarshalException"));
			errorCollection.Add(new ComErrors("NTE_FAIL", "CryptographicException"));
			errorCollection.Add(new ComErrors("COR_E_DIRECTORYNOTFOUND", "DirectoryNotFoundException"));
			errorCollection.Add(new ComErrors("ERROR_PATH_NOT_FOUND", "DirectoryNotFoundException"));
			errorCollection.Add(new ComErrors("COR_E_DIVIDEBYZERO", "DivideByZeroException"));
			errorCollection.Add(new ComErrors("COR_E_DUPLICATEWAITOBJECT", "DuplicateWaitObjectException"));
			errorCollection.Add(new ComErrors("COR_E_ENDOFSTREAM", "EndOfStreamException"));
			errorCollection.Add(new ComErrors("COR_E_TYPELOAD", "EntryPointNotFoundException"));
			errorCollection.Add(new ComErrors("COR_E_EXCEPTION", "Exception"));
			errorCollection.Add(new ComErrors("COR_E_EXECUTIONENGINE", "ExecutionEngineException"));
			errorCollection.Add(new ComErrors("COR_E_FIELDACCESS", "FieldAccessException"));
			errorCollection.Add(new ComErrors("COR_E_FILENOTFOUND", "FileNotFoundException"));
			errorCollection.Add(new ComErrors("ERROR_FILE_NOT_FOUND", "FileNotFoundException"));
			errorCollection.Add(new ComErrors("COR_E_FORMAT", "FormatException"));
			errorCollection.Add(new ComErrors("COR_E_INDEXOUTOFRANGE", "IndexOutOfRangeException"));
			errorCollection.Add(new ComErrors("COR_E_INVALIDCAST", "InvalidCastException"));
			errorCollection.Add(new ComErrors("E_NOINTERFACE", "InvalidCastException"));
			errorCollection.Add(new ComErrors("COR_E_INVALIDCOMOBJECT", "InvalidComObjectException"));
			errorCollection.Add(new ComErrors("COR_E_INVALIDFILTERCRITERIA", "InvalidFilterCriteriaException"));
			errorCollection.Add(new ComErrors("COR_E_INVALIDOLEVARIANTTYPE", "InvalidOleVariantTypeException"));
			errorCollection.Add(new ComErrors("COR_E_INVALIDOPERATION", "InvalidOperationException"));
			errorCollection.Add(new ComErrors("COR_E_IO", "IOException"));
			errorCollection.Add(new ComErrors("COR_E_MEMBERACCESS", "AccessException"));
			errorCollection.Add(new ComErrors("COR_E_METHODACCESS", "MethodAccessException"));
			errorCollection.Add(new ComErrors("COR_E_MISSINGFIELD", "MissingFieldException"));
			errorCollection.Add(new ComErrors("COR_E_MISSINGMANIFESTRESOURCE", "MissingManifestResourceException"));
			errorCollection.Add(new ComErrors("COR_E_MISSINGMEMBER", "MissingMemberException"));
			errorCollection.Add(new ComErrors("COR_E_MISSINGMETHOD", "MissingMethodException"));
			errorCollection.Add(new ComErrors("COR_E_MULTICASTNOTSUPPORTED", "MulticastNotSupportedException"));
			errorCollection.Add(new ComErrors("COR_E_NOTFINITENUMBER", "NotFiniteNumberException"));
			errorCollection.Add(new ComErrors("E_NOTIMPL", "NotImplementedException"));
			errorCollection.Add(new ComErrors("COR_E_NOTSUPPORTED", "NotSupportedException"));
			errorCollection.Add(new ComErrors("COR_E_NULLREFERENCE", "NullReferenceException"));
			errorCollection.Add(new ComErrors("E_POINTER", "NullReferenceException"));
			errorCollection.Add(new ComErrors("COR_E_OUTOFMEMORY", "OutOfMemoryException"));
			errorCollection.Add(new ComErrors("E_OUTOFMEMORY", "OutOfMemoryException"));
			errorCollection.Add(new ComErrors("COR_E_OVERFLOW", "OverflowException"));
			errorCollection.Add(new ComErrors("COR_E_PATHTOOLONG", "PathTooLongException"));
			errorCollection.Add(new ComErrors("ERROR_FILENAME_EXCED_RANGE", "PathTooLongException"));
			errorCollection.Add(new ComErrors("COR_E_RANK", "RankException"));
			errorCollection.Add(new ComErrors("COR_E_REFLECTIONTYPELOAD", "ReflectionTypeLoadException"));
			errorCollection.Add(new ComErrors("COR_E_REMOTING", "RemotingException"));
			errorCollection.Add(new ComErrors("COR_E_SAFEARRAYTYPEMISMATCH", "SafeArrayTypeMismatchException"));
			errorCollection.Add(new ComErrors("COR_E_SECURITY", "SecurityException"));
			errorCollection.Add(new ComErrors("COR_E_SERIALIZATION", "SerializationException"));
			errorCollection.Add(new ComErrors("COR_E_STACKOVERFLOW", "StackOverflowExceptionr"));
			errorCollection.Add(new ComErrors("ERROR_STACK_OVERFLOW", "StackOverflowException"));
			errorCollection.Add(new ComErrors("COR_E_SYNCHRONIZATIONLOCK", "SynchronizationLockException"));
			errorCollection.Add(new ComErrors("COR_E_SYSTEM", "SystemException"));
			errorCollection.Add(new ComErrors("COR_E_TARGET", "TargetException"));
			errorCollection.Add(new ComErrors("COR_E_TARGETINVOCATION", "TargetInvocationException"));
			errorCollection.Add(new ComErrors("COR_E_TARGETPARAMCOUNT", "TargetParameterCountException"));
			errorCollection.Add(new ComErrors("COR_E_THREADABORTED", "ThreadAbortException"));
			errorCollection.Add(new ComErrors("COR_E_THREADINTERRUPTED", "ThreadInterruptedException"));
			errorCollection.Add(new ComErrors("COR_E_THREADSTATE", "ThreadStateException"));
			errorCollection.Add(new ComErrors("COR_E_THREADSTOP", "ThreadStopException"));
			errorCollection.Add(new ComErrors("COR_E_TYPELOAD", "TypeLoadException"));
			errorCollection.Add(new ComErrors("COR_E_TYPEINITIALIZATION", "TypeInitializationException"));
			errorCollection.Add(new ComErrors("COR_E_VERIFICATION", "VerificationException"));
			errorCollection.Add(new ComErrors("E_FAIL", "COMException"));

			errorType.DataSource = errorCollection;
			errorType.DisplayMember = "Name";
			errorType.ValueMember = "Exception";
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
				tt = null;
				
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.colorDialog = new System.Windows.Forms.ColorDialog();
			this.colorButton = new System.Windows.Forms.Button();
			this.colorName = new System.Windows.Forms.TextBox();
			this.dateTime = new System.Windows.Forms.DateTimePicker();
			this.colorNameProperty = new System.Windows.Forms.TextBox();
			this.dateTimeProperty = new System.Windows.Forms.TextBox();
			this.currency = new System.Windows.Forms.TextBox();
			this.currencyProperty = new System.Windows.Forms.TextBox();
			this.name = new System.Windows.Forms.TextBox();
			this.nameProperty = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.variant = new System.Windows.Forms.TextBox();
			this.variantProperty = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.errorButton = new System.Windows.Forms.Button();
			this.errorText = new System.Windows.Forms.RichTextBox();
			this.inputGroupBox = new System.Windows.Forms.GroupBox();
			this.integerObjectRadio = new System.Windows.Forms.RadioButton();
			this.floatObjectRadio = new System.Windows.Forms.RadioButton();
			this.stringObjectRadio = new System.Windows.Forms.RadioButton();
			this.propertyGroupBox = new System.Windows.Forms.GroupBox();
			this.propertyIntegerRadio = new System.Windows.Forms.RadioButton();
			this.propertyFloatRadio = new System.Windows.Forms.RadioButton();
			this.propertyStringRadio = new System.Windows.Forms.RadioButton();
			this.label5 = new System.Windows.Forms.Label();
			this.arrayProperty = new System.Windows.Forms.TextBox();
			this.array = new System.Windows.Forms.TextBox();
			this.enumButton = new System.Windows.Forms.Button();
			this.enumeratorProperty = new System.Windows.Forms.TextBox();
			this.callbackCounter = new System.Windows.Forms.TextBox();
			this.errorType = new System.Windows.Forms.ComboBox();
			this.inputGroupBox.SuspendLayout();
			this.propertyGroupBox.SuspendLayout();
			this.SuspendLayout();
			// 
			// colorDialog
			// 
			this.colorDialog.AnyColor = true;
			// 
			// colorButton
			// 
			this.colorButton.Location = new System.Drawing.Point(60, 8);
			this.colorButton.Name = "colorButton";
			this.colorButton.Size = new System.Drawing.Size(92, 29);
			this.colorButton.TabIndex = 0;
			this.colorButton.Text = "Kolor";
			this.colorButton.Click += new System.EventHandler(this.OnColorButtonClick);
			// 
			// colorName
			// 
			this.colorName.Location = new System.Drawing.Point(178, 8);
			this.colorName.Name = "colorName";
			this.colorName.ReadOnly = true;
			this.colorName.Size = new System.Drawing.Size(151, 23);
			this.colorName.TabIndex = 1;
			this.colorName.Text = "";
			// 
			// dateTime
			// 
			this.dateTime.Location = new System.Drawing.Point(60, 48);
			this.dateTime.Name = "dateTime";
			this.dateTime.Size = new System.Drawing.Size(269, 23);
			this.dateTime.TabIndex = 2;
			this.dateTime.ValueChanged += new System.EventHandler(this.OnDateTimeChange);
			// 
			// colorNameProperty
			// 
			this.colorNameProperty.Location = new System.Drawing.Point(338, 8);
			this.colorNameProperty.Name = "colorNameProperty";
			this.colorNameProperty.ReadOnly = true;
			this.colorNameProperty.Size = new System.Drawing.Size(124, 23);
			this.colorNameProperty.TabIndex = 3;
			this.colorNameProperty.Text = "";
			// 
			// dateTimeProperty
			// 
			this.dateTimeProperty.Location = new System.Drawing.Point(338, 48);
			this.dateTimeProperty.Name = "dateTimeProperty";
			this.dateTimeProperty.ReadOnly = true;
			this.dateTimeProperty.Size = new System.Drawing.Size(258, 23);
			this.dateTimeProperty.TabIndex = 4;
			this.dateTimeProperty.Text = "";
			// 
			// currency
			// 
			this.currency.Location = new System.Drawing.Point(60, 80);
			this.currency.Name = "currency";
			this.currency.Size = new System.Drawing.Size(269, 23);
			this.currency.TabIndex = 5;
			this.currency.Text = "";
			this.currency.Validating += new System.ComponentModel.CancelEventHandler(this.OnCurrencyValidating);
			// 
			// currencyProperty
			// 
			this.currencyProperty.Location = new System.Drawing.Point(338, 80);
			this.currencyProperty.Name = "currencyProperty";
			this.currencyProperty.ReadOnly = true;
			this.currencyProperty.Size = new System.Drawing.Size(258, 23);
			this.currencyProperty.TabIndex = 6;
			this.currencyProperty.Text = "";
			// 
			// name
			// 
			this.name.Location = new System.Drawing.Point(60, 112);
			this.name.Name = "name";
			this.name.Size = new System.Drawing.Size(269, 23);
			this.name.TabIndex = 7;
			this.name.Text = "";
			this.name.Validating += new System.ComponentModel.CancelEventHandler(this.OnNameValidating);
			// 
			// nameProperty
			// 
			this.nameProperty.Location = new System.Drawing.Point(338, 112);
			this.nameProperty.Name = "nameProperty";
			this.nameProperty.ReadOnly = true;
			this.nameProperty.Size = new System.Drawing.Size(258, 23);
			this.nameProperty.TabIndex = 8;
			this.nameProperty.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(0, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(50, 20);
			this.label1.TabIndex = 9;
			this.label1.Text = "Data";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(0, 88);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(50, 22);
			this.label2.TabIndex = 10;
			this.label2.Text = "Waluta";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(0, 120);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(50, 21);
			this.label3.TabIndex = 11;
			this.label3.Text = "BSTR";
			// 
			// variant
			// 
			this.variant.Location = new System.Drawing.Point(60, 144);
			this.variant.Name = "variant";
			this.variant.Size = new System.Drawing.Size(269, 23);
			this.variant.TabIndex = 12;
			this.variant.Text = "";
			this.variant.Validating += new System.ComponentModel.CancelEventHandler(this.OnObjectValidating);
			// 
			// variantProperty
			// 
			this.variantProperty.Location = new System.Drawing.Point(338, 144);
			this.variantProperty.Name = "variantProperty";
			this.variantProperty.ReadOnly = true;
			this.variantProperty.Size = new System.Drawing.Size(258, 23);
			this.variantProperty.TabIndex = 13;
			this.variantProperty.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(0, 152);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(50, 21);
			this.label4.TabIndex = 14;
			this.label4.Text = "Var";
			// 
			// errorButton
			// 
			this.errorButton.Location = new System.Drawing.Point(56, 280);
			this.errorButton.Name = "errorButton";
			this.errorButton.Size = new System.Drawing.Size(94, 29);
			this.errorButton.TabIndex = 15;
			this.errorButton.Text = "Bd";
			this.errorButton.Click += new System.EventHandler(this.OnErrorClick);
			// 
			// errorText
			// 
			this.errorText.Location = new System.Drawing.Point(56, 312);
			this.errorText.Name = "errorText";
			this.errorText.Size = new System.Drawing.Size(536, 120);
			this.errorText.TabIndex = 16;
			this.errorText.Text = "";
			// 
			// inputGroupBox
			// 
			this.inputGroupBox.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.integerObjectRadio,
																						this.floatObjectRadio,
																						this.stringObjectRadio});
			this.inputGroupBox.Location = new System.Drawing.Point(61, 168);
			this.inputGroupBox.Name = "inputGroupBox";
			this.inputGroupBox.Size = new System.Drawing.Size(117, 107);
			this.inputGroupBox.TabIndex = 17;
			this.inputGroupBox.TabStop = false;
			this.inputGroupBox.Text = "Typ obiektu";
			// 
			// integerObjectRadio
			// 
			this.integerObjectRadio.Location = new System.Drawing.Point(7, 74);
			this.integerObjectRadio.Name = "integerObjectRadio";
			this.integerObjectRadio.Size = new System.Drawing.Size(102, 25);
			this.integerObjectRadio.TabIndex = 2;
			this.integerObjectRadio.Text = "Liczba cakowita";
			// 
			// floatObjectRadio
			// 
			this.floatObjectRadio.Location = new System.Drawing.Point(7, 49);
			this.floatObjectRadio.Name = "floatObjectRadio";
			this.floatObjectRadio.Size = new System.Drawing.Size(102, 25);
			this.floatObjectRadio.TabIndex = 1;
			this.floatObjectRadio.Text = "Liczba zmiennoprzecinkowa";
			// 
			// stringObjectRadio
			// 
			this.stringObjectRadio.Location = new System.Drawing.Point(7, 25);
			this.stringObjectRadio.Name = "stringObjectRadio";
			this.stringObjectRadio.Size = new System.Drawing.Size(102, 24);
			this.stringObjectRadio.TabIndex = 0;
			this.stringObjectRadio.Text = "Cig";
			// 
			// propertyGroupBox
			// 
			this.propertyGroupBox.Controls.AddRange(new System.Windows.Forms.Control[] {
																						   this.propertyIntegerRadio,
																						   this.propertyFloatRadio,
																						   this.propertyStringRadio});
			this.propertyGroupBox.Location = new System.Drawing.Point(341, 176);
			this.propertyGroupBox.Name = "propertyGroupBox";
			this.propertyGroupBox.Size = new System.Drawing.Size(117, 107);
			this.propertyGroupBox.TabIndex = 18;
			this.propertyGroupBox.TabStop = false;
			this.propertyGroupBox.Text = "Typ obiektu";
			// 
			// propertyIntegerRadio
			// 
			this.propertyIntegerRadio.Location = new System.Drawing.Point(7, 74);
			this.propertyIntegerRadio.Name = "propertyIntegerRadio";
			this.propertyIntegerRadio.Size = new System.Drawing.Size(102, 25);
			this.propertyIntegerRadio.TabIndex = 2;
			this.propertyIntegerRadio.Text = "Liczba cakowita";
			// 
			// propertyFloatRadio
			// 
			this.propertyFloatRadio.Location = new System.Drawing.Point(7, 49);
			this.propertyFloatRadio.Name = "propertyFloatRadio";
			this.propertyFloatRadio.Size = new System.Drawing.Size(102, 25);
			this.propertyFloatRadio.TabIndex = 1;
			this.propertyFloatRadio.Text = "Liczba zmiennoprzecinkowa";
			// 
			// propertyStringRadio
			// 
			this.propertyStringRadio.Location = new System.Drawing.Point(7, 25);
			this.propertyStringRadio.Name = "propertyStringRadio";
			this.propertyStringRadio.Size = new System.Drawing.Size(102, 24);
			this.propertyStringRadio.TabIndex = 0;
			this.propertyStringRadio.Text = "Cig";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(7, 448);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(50, 20);
			this.label5.TabIndex = 19;
			this.label5.Text = "Tablica";
			// 
			// arrayProperty
			// 
			this.arrayProperty.Location = new System.Drawing.Point(341, 440);
			this.arrayProperty.Name = "arrayProperty";
			this.arrayProperty.ReadOnly = true;
			this.arrayProperty.Size = new System.Drawing.Size(258, 23);
			this.arrayProperty.TabIndex = 21;
			this.arrayProperty.Text = "";
			// 
			// array
			// 
			this.array.Location = new System.Drawing.Point(60, 440);
			this.array.Name = "array";
			this.array.Size = new System.Drawing.Size(269, 23);
			this.array.TabIndex = 20;
			this.array.Text = "";
			this.array.Validating += new System.ComponentModel.CancelEventHandler(this.OnArrayValidating);
			// 
			// enumButton
			// 
			this.enumButton.Location = new System.Drawing.Point(60, 472);
			this.enumButton.Name = "enumButton";
			this.enumButton.Size = new System.Drawing.Size(93, 28);
			this.enumButton.TabIndex = 22;
			this.enumButton.Text = "Enumerator";
			this.enumButton.Click += new System.EventHandler(this.OnEnumClick);
			// 
			// enumeratorProperty
			// 
			this.enumeratorProperty.Location = new System.Drawing.Point(340, 472);
			this.enumeratorProperty.Name = "enumeratorProperty";
			this.enumeratorProperty.ReadOnly = true;
			this.enumeratorProperty.Size = new System.Drawing.Size(258, 23);
			this.enumeratorProperty.TabIndex = 23;
			this.enumeratorProperty.Text = "";
			// 
			// callbackCounter
			// 
			this.callbackCounter.ForeColor = System.Drawing.SystemColors.ControlText;
			this.callbackCounter.Location = new System.Drawing.Point(564, 8);
			this.callbackCounter.Name = "callbackCounter";
			this.callbackCounter.ReadOnly = true;
			this.callbackCounter.Size = new System.Drawing.Size(34, 23);
			this.callbackCounter.TabIndex = 24;
			this.callbackCounter.Text = "";
			this.callbackCounter.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// errorType
			// 
			this.errorType.Location = new System.Drawing.Point(168, 280);
			this.errorType.Name = "errorType";
			this.errorType.Size = new System.Drawing.Size(296, 24);
			this.errorType.TabIndex = 25;
			this.errorType.Text = "E_FAIL";
			// 
			// TypeTesterForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 16);
			this.ClientSize = new System.Drawing.Size(624, 509);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.errorType,
																		  this.callbackCounter,
																		  this.enumeratorProperty,
																		  this.enumButton,
																		  this.arrayProperty,
																		  this.array,
																		  this.label5,
																		  this.inputGroupBox,
																		  this.errorText,
																		  this.errorButton,
																		  this.label4,
																		  this.variantProperty,
																		  this.variant,
																		  this.label3,
																		  this.label2,
																		  this.label1,
																		  this.nameProperty,
																		  this.name,
																		  this.currencyProperty,
																		  this.currency,
																		  this.dateTimeProperty,
																		  this.colorNameProperty,
																		  this.dateTime,
																		  this.colorName,
																		  this.colorButton,
																		  this.propertyGroupBox});
			this.Font = new System.Drawing.Font("Garamond", 10.2F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "TypeTesterForm";
			this.Text = "Type Tester";
			this.inputGroupBox.ResumeLayout(false);
			this.propertyGroupBox.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new TypeTesterForm());
		}

		private void OnDateTimeChange(object sender, System.EventArgs e)
		{
			DateTimePicker dtp = sender as DateTimePicker;
			tt.Date = dtp.Value;
		}

		private void OnColorButtonClick(object sender, System.EventArgs e)
		{
			colorDialog.ShowDialog();
			colorName.Text = colorDialog.Color.ToString();
			tt.Color = colorDialog.Color;
		}

		private void OnCurrencyValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			tt.Currency = Convert.ToDecimal(currency.Text);
		}

		private void OnNameValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			tt.Name = name.Text;
		}

		private void OnErrorClick(object sender, System.EventArgs e)
		{
			try
			{
				tt.ErrorTest(errorType.Text);
			}
			catch(Exception exception)
			{
				errorText.Text = exception.ToString();
			}
		}

		private void OnObjectValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			propertyIntegerRadio.Checked = false;
			propertyFloatRadio.Checked = false;
			propertyStringRadio.Checked = false;
			if(stringObjectRadio.Checked)
			{
				try
				{
					string s = variant.Text;
					tt.Object = s;
					propertyStringRadio.Checked = true;
				}
				catch(Exception exception)
				{
					Debug.WriteLine(exception);
				}
			}
			if(floatObjectRadio.Checked)
			{
				try
				{
					float f = Convert.ToSingle(variant.Text);
					tt.Object = f;
					propertyFloatRadio.Checked = true;
				}
				catch(Exception exception)
				{
					Debug.WriteLine(exception);
				}
			}
			if(integerObjectRadio.Checked)
			{
				try
				{
					int i = Convert.ToInt32(variant.Text);
					tt.Object = i;
					propertyIntegerRadio.Checked = true;
				}
				catch(Exception exception)
				{
					Debug.WriteLine(exception);
				}
			}
		}

		private void OnArrayValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			string [] sa = array.Text.Split(',');
			object [] oa = new object [sa.Length];
			bool arrayCheck = true;
			// Sprawdzenie liczby cakowitej
			for(int i = 0; i < sa.Length && arrayCheck; i++)
			{
				try
				{
					oa[i] = Convert.ToInt32(sa[i]);
				}
				catch(Exception)
				{
					arrayCheck = false;
				}
			}
			if(arrayCheck == false)
			{
				arrayCheck = true;
				// Sprawdzenie liczby zmiennoprzecinkowej
				for(int i = 0; i < sa.Length && arrayCheck; i++)
				{
					try
					{
						oa[i] = Convert.ToSingle(sa[i]);
					}
					catch(Exception)
					{
						arrayCheck = false;
					}
				}
			}
			if(arrayCheck == false)
			{
				arrayCheck = true;
				// Uycie cigu
				for(int i = 0; i < sa.Length; i++)
				{
					oa[i] = sa[i];
				}
			}
			// Zapisanie tablicy
			tt.Array = oa;
		}

		private void OnEnumClick(object sender, System.EventArgs e)
		{
			StringBuilder sb = new StringBuilder();
			IEnumerator en = tt.Enumerator;
			while(en.MoveNext())
			{
				sb.Append(en.Current.ToString());
				sb.Append(" ");
			}
			enumeratorProperty.Text = sb.ToString();
		}
	}
}
